---------------------------------------------------------------------------
-- SQL w praktyce. Jak dzięki danym uzyskiwać cenne informacje. Wydanie II
-- Anthony DeBarros

-- Wypróbuj to sam - pytania i odpowiedzi
----------------------------------------------------------------------------

----------------------------------------------------------------------------
-- Rozdział 2.: Tworzenie pierwszej bazy danych i tabeli
----------------------------------------------------------------------------

-- 1.	Wyobraź sobie, że budujesz bazę danych służącą do katalogowania wszystkich 
-- zwierząt znajdujących się w lokalnym zoo. Wymagasz jednej tabeli do śledzenia 
-- gatunków zwierząt z całej kolekcji oraz kolejnej tabeli do monitorowania szczegółów 
-- każdego zwierzęcia. Utwórz instrukcję CREATE TABLE dla każdej tabeli, która obejmuje 
-- część niezbędnych kolumn. Dlaczego uwzględniłeś wybranie przez siebie kolumny?

-- Odpowiedź (Twoja będzie inna):

-- Pierwsza tabela będzie przechowywać gatunki zwierząt oraz ich status ochrony:

CREATE TABLE animal_types (
    animal_type_id bigint PRIMARY KEY GENERATED ALWAYS AS IDENTITY,
    common_name text NOT NULL,
    scientific_name text NOT NULL,
    conservation_status text NOT NULL,
    CONSTRAINT common_name_unique UNIQUE (common_name)
);

-- Nie stanowi problemu to, jeśli Twoja odpowiedź nie zawiera wszystkich słów kluczowych z powyższego przykładu. Te
-- słowa kluczowe odnoszą się do koncepcji, które poznasz w kolejnych rozdziałach, w tym do ograniczeń tabeli,
-- kluczy głównych i kolumn IDENTITY. Ważne jest, abyś rozważył poszczególne elementy danych, które mają być śledzone.


-- Druga tabela będzie zawierać dane o poszczególnych zwierzętach. Zauważ, że kolumna animal_type_id odnosi się do kolumny o tej samej nazwie
-- w tabeli gatunków zwierząt. Jest to klucz obcy, o którym dowiesz się w rozdziale 8.

CREATE TABLE menagerie (
   menagerie_id bigint PRIMARY KEY GENERATED ALWAYS AS IDENTITY,
   common_name text REFERENCES animal_types (common_name),
   date_acquired date NOT NULL,
   gender text,
   acquired_from text,
   name text,
   notes text
);

-- 2. Utwórz instrukcje INSERT, aby do tabel załadować przykładowe dane. 
-- Jak możesz wyświetlić dane za pomocą narzędzia pgAdmin?

-- Odpowiedź (ponownie Twoja będzie inna):

INSERT INTO animal_types (common_name, scientific_name, conservation_status)
VALUES ('Bengal Tiger', 'Panthera tigris tigris', 'Endangered'),
       ('Arctic Wolf', 'Canis lupus arctos', 'Least Concern');
-- źródło danych: https://www.worldwildlife.org/species/directory?direction=desc&sort=extinction_status

INSERT INTO menagerie (common_name, date_acquired, gender, acquired_from, name, notes)
VALUES
('Bengal Tiger', '3/12/1996', 'F', 'Dhaka Zoo', 'Ariel', 'Healthy coat at last exam.'),
('Arctic Wolf', '9/30/2000', 'F', 'National Zoo', 'Freddy', 'Strong appetite.');

-- Aby wyświetlić dane za pomocą narzędzia pgAdmin, w przeglądarce obiektów kliknij prawym przyciskiem myszy menu Tabele i
-- wybierz pozycję Refresh. Kliknij następnie prawym przyciskiem myszy nazwę tabeli i z menu 
-- View/Edit Data wybierz pozycję All Rows.


-- 2b. Utwórz dodatkowe polecenie INSERT dla jednej z Twoich tabel. Celowo
-- pomiń jeden z wymaganych przecinków oddzielających pozycje w klauzuli VALUES
-- zapytania. Jaki jest komunikat o błędzie? Czy pomaga on znaleźć
-- błąd w kodzie?


-- Odpowiedź: w tym przypadku komunikat o błędzie wskazuje na brakujący przecinek.

INSERT INTO animal_types (common_name, scientific_name, conservation_status)
VALUES ('Javan Rhino', 'Rhinoceros sondaicus' 'Critically Endangered');


----------------------------------------------------------------------------
-- Rozdział 3.: Rozpoczęcie eksplorowania danych za pomocą instrukcji SELECT
----------------------------------------------------------------------------

-- 1. Dyrektor nadzorujący okręg szkół prosi o listę nauczycieli w każdej szkole.
-- Utwórz zapytanie, które tworzy listę szkół uporządkowanych w kolejności alfabetycznej
-- wraz z nauczycielami posortowanymi według nazwiska, począwszy od litery A.

-- Odpowiedź:

SELECT school, first_name, last_name
FROM teachers
ORDER BY school, last_name;

-- 2. Utwórz zapytanie znajdujące nauczyciela, którego imię zaczyna się od litery S,
-- a zarobki przekraczają 40000 dolarów.

-- Odpowiedź:

SELECT first_name, last_name, school, salary
FROM teachers
WHERE first_name LIKE 'S%' -- pamiętaj, że LIKE rozróżnia wielkość znaków!
      AND salary > 40000;

-- 3. Sporządź zestawienie nauczycieli zatrudnionych od 1 stycznia 2010 r. uporządkowanych w kolejności od zarabiających najwięcej.

-- Odpowiedź:

SELECT last_name, first_name, school, hire_date, salary
FROM teachers
WHERE hire_date >= '2010-01-01'
ORDER BY salary DESC;


----------------------------------------------------------------------------
-- Rozdział 4.: Typy danych
----------------------------------------------------------------------------

-- 1. 1.	Twoja firma dostarcza owoce i warzywa do lokalnych sklepów spożywczych, 
-- dlatego musisz monitorować ilość kilometrów przejechanych codziennie przez każdego 
-- kierowcę z dokładnością do części dziesiętnej kilometra. Zakładając, że żaden kierowca 
-- nie pokonał dotąd w ciągu jednego dnia więcej niż 999 kilometrów, jaki będzie odpowiedni 
-- typ danych w przypadku kolumny kilometrażu tabeli? Wyjaśnij, dlaczego?

-- Odpowiedź:

numeric(4,1)

-- numeric(4,1) zapewnia w sumie cztery cyfry (precyzja) i jedną cyfrę po
-- znaku dziesiętnym (skala). Pozwala to na przechowywanie wartości tak dużych
-- jak 999.9.


-- W praktyce warto rozważyć, że założona maksymalna liczba mil
-- w ciągu dnia może przekroczyć 999.9, dlatego można wybrać większy zakres: numeric(5,1).


-- 2. Jakie są właściwe typy danych kolumn z imieniem i nazwiskiem kierowców w ramach 
-- tabeli zawierającej dane każdego kierowcy pracującego w Twojej firmie? Dlaczego dobrym 
-- pomysłem jest rozdzielenie imienia i nazwiska w dwóch kolumnach zamiast stosowania 
-- jednej większej kolumny z personaliami?


-- Odpowiedź:

varchar(50)
-- lub
text

-- 50 znaków to rozsądna długość dla nazwisk, a użycie varchar(50)
-- lub text zapewnia, że nie zmarnujesz miejsca, gdy nazwy będą krótsze. Użycie text
-- zapewnia, że w przypadku wyjątkowo rzadkiej sytuacji, gdy nazwisko przekroczy
-- 50 znaków, będziesz na to przygotowany. Ponadto, rozdzielenie imion i nazwisk
-- w osobnych kolumnach pozwoli później sortować je niezależnie.



-- 3. Przyjmij, że istnieje kolumna tekstowa zawierająca łańcuchy sformatowane jako daty. 
-- Jeden z łańcuchów zapisano w postaci 4//2021. Co się stanie, gdy spróbujesz przekształcić 
-- ten łańcuch z użyciem typu danych timestamp?

-- Odpowiedź: Próba konwersji łańcucha tekstowego, który nie jest zgodny z
-- akceptowanymi formatami daty/czasu, spowoduje błąd. Możesz się o tym przekpnać w poniższym
-- przykładzie, w którym spróbowano rzutowania łańcucha jako typu timestamp.

SELECT CAST('4//2021' AS timestamp with time zone);


----------------------------------------------------------------------------
-- Rozdział 5.: Importowanie i eksportowanie danych
----------------------------------------------------------------------------

-- 1. Utwórz kod klauzuli WITH, który zostanie dołączony do instrukcji COPY, aby zapewniła obsługę importowania fikcyjnego pliku tekstowego, którego kilka pierwszych wierszy ma następującą postać:

id:movie:actor
50:#Mission: Impossible#:Tom Cruise

-- Odpowiedź: instrukcja WITH będzie wymagać użytych tutaj opcji:

COPY actors
FROM 'C:\TwojKatalog\movies.txt'
WITH (FORMAT CSV, HEADER, DELIMITER ':', QUOTE '#');

-- Jeśli chcesz spróbować faktycznie zaimportować te dane, zapisz dane w pliku
-- o nazwie movies.txt i utwórz poniższą tabelę aktorów. Możesz następnie uruchomić polecenie COPY.


CREATE TABLE actors (
    id integer,
    movie text,
    actor text
);

-- Uwaga: możesz nigdy nie spotkać się z plikiem, w którym użyto dwukropka jako ogranicznika i
-- znaku funta jako cudzysłowu, ale wszystko jest możliwe!



-- 2. Używając tabeli us_counties_pop_est_2019 utworzonej i wypełnionej w tym rozdziale, 
-- wyeksportuj do pliku CSV 20 hrabstw położonych w Stanach Zjednoczonych, w przypadku których
-- było najwięcej urodzeń. Zadbaj o to, by dla każdego hrabstwa została wyeksportowana tylko jego nazwa,
-- nazwa stanu oraz liczba urodzeń (wskazówka: łączną liczbę urodzeń dla poszczególnych hrabstw podano w kolumnie births_2019).

-- Odpowiedź:

COPY (
    SELECT county_name, state_name, births_2019
    FROM us_counties_pop_est_2019 ORDER BY births_2019 DESC LIMIT 20
     )
TO 'C:\TwojKatalog\us_counties_births_export.txt'
WITH (FORMAT CSV, HEADER);

-- Uwaga: To polecenie COPY używa instrukcji SELECT, aby ograniczyć dane wyjściowe do
-- tylko wymaganych kolumn i wierszy.



-- 3. Wyobraź sobie, że importujesz plik zawierający kolumnę z następującymi wartościami:
--      17519.668
--      20084.461
--      18976.335
--    Czy w przypadku tych wartości sprawdzi się kolumna z typem danych numeric(3,8) 
--    w Twojej tabeli docelowej? Uzasadnij swoją odpowiedź.


-- Odpowiedź:
-- Nie. W rzeczywistości nie będziesz nawet w stanie utworzyć kolumny z tym
-- typem danych, ponieważ precyzja musi być większa niż skala. Prawidłowy
-- typ dla przykładowych danych to numeric(8,3).



----------------------------------------------------------------------------
-- Rozdział 6.: Podstawowe operacje matematyczne i statystyczne w języku SQL
----------------------------------------------------------------------------

-- 1. Utwórz instrukcję języka SQL obliczającą powierzchnię koła o promieniu 5 cm 
-- (jeśli nie pamiętasz wymaganego wzoru, z łatwością znajdziesz go w internecie). 
--  Czy w obliczeniu są wymagane nawiasy okrągłe? Uzasadnij swoją odpowiedź.

-- Odpowiedź:
-- (wzór powierzchni koła to: liczba pi * promień do kwadratu.)

SELECT 3.14 * 5 ^ 2;

-- Wynik to obszar o powierzchni 78.5 cali kwadratowych.
-- Uwaga: nie potrzebujesz nawiasów okrągłych, ponieważ potęgi i pierwiastki mają pierwszeństwo
-- względem mnożenia. Możesz jednak dodać nawiasy dla zwiększenia przejrzystości. To
-- polecenie zapewnia ten sam wynik:

SELECT 3.14 * (5 ^ 2);


-- 2. Korzystając z danych szacunkowych spisu ludności przeprowadzonego przez urząd 
-- Stanów Zjednoczonych w 2019 r., oblicz wskaźnik urodzeń do zgonów dla każdego hrabstwa 
-- w stanie Nowy Jork. W przypadku jakiego regionu tego stanu w roku 2019 generalnie wystąpił 
-- wyższy wskaźnik urodzeń do zgonów?

-- Odpowiedź:

SELECT county_name,
       state_name,
       births_2019 AS births,
       deaths_2019 AS deaths,
       births_2019::numeric / deaths_2019 AS birth_death_ratio
FROM us_counties_pop_est_2019
WHERE state_name = 'New York'
ORDER BY birth_death_ratio DESC;

-- Ogólnie rzecz biorąc, hrabstwa w okolicach Nowego Jorku miały w danych szacunkowych z 2019 roku
-- najwyższy stosunek urodzeń do zgonów. Wyjątkiem od tej tendencji jest hrabstwo  Jefferson,
-- które znajduje się w północnej części stanu na granicy Stanów Zjednoczonych i Kanady.


-- Uwaga: W 2019 r. było sześć hrabstw w Stanach Zjednoczonych, w których nie odnotowano żadnych zgonów. Zgodnie
-- z danymi z tego zbioru dotyczy to stanów: Hawaje, Nebraska, Północna Dakota i Teksas. Jeśli zmodyfikujesz
-- zapytanie, aby odfiltrowało jeden z tych stanów, będziesz musiał dostosować klauzulę WHERE, aby wyeliminować
-- te hrabstwa bez zgonów, ponieważ dzielenie przez zero  jest niedozwolone. W tym celu zmodyfikuj swoją klauzulę WHERE 
-- w następujący sposób:


WHERE state_name = 'Texas' AND deaths_2019 > 0


-- 3. Czy mediana szacunkowej populacji ludności hrabstw w 2019 r. była większa dla stanu Kalifornia czy dla stanu Nowy Jork?

-- Odpowiedź:
-- W 2019 r. stan Kalifornia miał medianę szacunkowej liczby ludności w hrabstwach wynoszącą 187 029, czyli prawie dwukrotnie
-- więcej niż stan Nowy Jork z liczbą wynoszącą 86 687. Oto dwa rozwiązania:

-- Po pierwsze, możesz wyznaczyć medianę dla każdego stanu osobno:

SELECT percentile_cont(.5)
        WITHIN GROUP (ORDER BY pop_est_2019)
FROM us_counties_pop_est_2019
WHERE state_name = 'New York';

SELECT percentile_cont(.5)
        WITHIN GROUP (ORDER BY pop_est_2019)
FROM us_counties_pop_est_2019
WHERE state_name = 'California';

-- Albo dla obu stanów w ramach jednego zapytania (źródło: https://github.com/Kennith-eng)

SELECT state_name,
       percentile_cont(0.5)
          WITHIN GROUP (ORDER BY pop_est_2019) AS median
FROM us_counties_pop_est_2019
WHERE state_name IN ('New York', 'California')
GROUP BY state_name;

-- I wreszcie, zapytanie to podaje medianę dla każdego stanu:

SELECT state_name,
       percentile_cont(0.5)
          WITHIN GROUP (ORDER BY pop_est_2019) AS median
FROM us_counties_pop_est_2019
GROUP BY state_name;


----------------------------------------------------------------------------
-- Rozdział 7.: Łączenie tabel w relacyjnej bazie danych
----------------------------------------------------------------------------

-- 1. Jakie hrabstwo, zgodnie z danymi szacunkowymi dotyczącymi populacji ze spisu ludności, 
-- zanotowało największy procentowy spadek populacji w okresie między rokiem 2010 i 2019? 
-- Spróbuj poszukać w internecie poszukać informacji o tym, co się wydarzyło (wskazówka: spadek liczby 
-- ludności ma związek z konkretnym typem obiektu).

-- Odpowiedź: 

-- Powiat Concho w Teksasie utracił 33 procent swojej populacji w latach 2010-2019
-- w wyniku zamknięcia więzienia Eden Detention Center.
-- https://www.texasstandard.org/stories/after-edens-prison-closes-what-comes-next-for-this-small-texas-town/


-- Po prostu użyj ASC w klauzuli ORDER BY, aby zmienić kolejność wyników w następujący sposób:
SELECT c2019.county_name,
       c2019.state_name,
       c2019.pop_est_2019 AS pop_2019,
       c2010.estimates_base_2010 AS pop_2010,
       c2019.pop_est_2019 - c2010.estimates_base_2010 AS raw_change,
       round( (c2019.pop_est_2019::numeric - c2010.estimates_base_2010)
           / c2010.estimates_base_2010 * 100, 1 ) AS pct_change       
FROM us_counties_pop_est_2019 AS c2019
    JOIN us_counties_pop_est_2010 AS c2010
ON c2019.state_fips = c2010.state_fips
    AND c2019.county_fips = c2010.county_fips
ORDER BY pct_change ASC;


-- 2. Wykorzystaj objaśnione pojęcia związane z operatorem UNION do uzyskania wyniku zapytań, 
-- w ramach którego scalono zapytania odnoszące się do danych szacunkowych z roku 2010 i roku 2019 
-- dotyczących populacji w hrabstwach objętych spisem ludności. Twoje wyniki powinny uwzględniać 
-- kolumnę o nazwie year określającą dla każdego wiersza wynikowego rok, którego dotyczą dane szacunkowe.

-- Odpowiedź:
-- Zauważ, że w obu zapytaniach przekazuje się łańcuch jako rok.
SELECT '2010' AS year,
       state_fips,
       county_fips,
       county_name,
       state_name,
       estimates_base_2010 AS estimate
FROM us_counties_pop_est_2010
UNION 
SELECT '2019' AS year,
       state_fips,
       county_fips,
       county_name,
       state_name,       
       pop_est_2019 AS estimate
FROM us_counties_pop_est_2019
ORDER BY state_fips, county_fips, year;


-- 3. Używając funkcji percentile_cont() z rozdziału 6., wyznacz medianę zmiany procentowej w przypadku szacunkowej
-- populacji w hrabstwach w przedziale między rokiem 2010 i rokiem 2019.

-- Odpowiedź: -0.5%

SELECT percentile_cont(.5)
       WITHIN GROUP (ORDER BY round( (c2019.pop_est_2019::numeric - c2010.estimates_base_2010)
           / c2010.estimates_base_2010 * 100, 1 )) AS percentile_50th
FROM us_counties_pop_est_2019 AS c2019
    JOIN us_counties_pop_est_2010 AS c2010
ON c2019.state_fips = c2010.state_fips
    AND c2019.county_fips = c2010.county_fips;
    

----------------------------------------------------------------------------
-- Rozdział 8.: Optymalny projekt tabel
----------------------------------------------------------------------------

-- Przeanalizuj dwie poniższe tabele z bazy danych, którą tworzysz, aby monitorować
-- swoją kolekcję płyt winylowych. Zacznij od przejrzenia tych instrukcji CREATE TABLE.


CREATE TABLE albums (
    album_id bigint GENERATED ALWAYS AS IDENTITY,
    catalog_code text,
    title text,
    artist text,
    release_date date,
    genre text,
    description text
);

CREATE TABLE songs (
    song_id bigint GENERATED ALWAYS AS IDENTITY,
    title text,
    composers text,
    album_id bigint
);

-- Tabela albums zawiera informacje dotyczące całej kolekcji utworów na płycie. 
-- Tabela songs kataloguje każdy utwór albumu. Każdy utwór ma tytuł, a także powiązaną kolumnę 
-- z jego kompozytorami, którzy mogą być inni niż artysta odpowiadający za album.

-- Użyj tabel, aby odpowiedzieć na następujące pytania:
-- 1. Zmodyfikuj instrukcje CREATE TABLE w celu uwzględnienia dla obu tabel kluczy głównych i obcych
-- oraz dodatkowych ograniczeń. Wyjaśnij, dlaczego zdecydowałeś się na swoje opcje wyboru.


-- Odpowiedź (Twoja może być trochę inna):

CREATE TABLE albums (
    album_id bigint GENERATED ALWAYS AS IDENTITY,
    catalog_code text NOT NULL,
    title text NOT NULL,
    artist text NOT NULL,
    release_date date,
    genre text,
    description text,
    CONSTRAINT album_id_key PRIMARY KEY (album_id),
    CONSTRAINT release_date_check CHECK (release_date > '1/1/1925')
);

CREATE TABLE songs (
    song_id bigint GENERATED ALWAYS AS IDENTITY,
    title text NOT NULL,
    composer text NOT NULL,
    album_id bigint REFERENCES albums (album_id),
    CONSTRAINT song_id_key PRIMARY KEY (song_id)
);

-- Odpowiedzi:
-- a) Obie tabele uzyskują klucz główny za pomocą wartości identyfikatora klucza zastępczego, które są
-- automatycznie generowane z użyciem IDENTITY.

-- b) Tabela songs odnosi się do tabeli albums za pośrednictwem ograniczenia klucza obcego.

-- c) W obu tabelach kolumny title i artist/composer nie mogą być puste, co
-- jest określone za pomocą ograniczenia NOT NULL. Założono, że każdy album i
-- piosenka powinny zawierać przynajmniej te informacje.

-- d) W tabeli albums kolumna release_date ma ograniczenie CHECK
-- ponieważ prawdopodobnie niemożliwe będzie posiadanie płyty wyprodukowanej przed 1925 r.



-- 2.	Czy zamiast użycia kolumny album_id jako klucza zastępczego pełniącego rolę klucza głównego, 
-- w tabeli albums istnieją jakiekolwiek kolumny, które mogłyby okazać się przydatne jako klucz naturalny? 
-- Co musiałbyś wiedzieć, żeby podjąć decyzję?

-- Odpowiedź:
-- Można rozważyć kolumnę catalog_code. Trzeba byłoby odpowiedzieć twierdząco na
-- następujące pytania:
-- 1. Czy kolumna będzie unikalna dla wszystkich albumów wydanych przez wszystkie firmy?
-- 2. Czy album zawsze będzie miał kod katalogowy?
-- 3. Jakie kolumny z myślą o przyspieszeniu zapytań są odpowiednimi kandydatami do bycia indeksami?

-- Odpowiedź:
-- Kolumny klucza głównego stają się indeksami domyślnie, ale powinno się dodać indeks
-- do kolumny klucza obcego album_id tabeli songs, ponieważ będzie używany
-- w złączeniach tabel. Prawdopodobnie do tabel tych będą kierowane zapytania w celu wyszukiwania
-- według tytułów i artystów, dlatego kolumny te w obu tabelach również powinny mieć indeksy.
-- Kolumna release_date w tabeli albums także jest kandydatem, jeśli planuje się wykonywanie
-- wielu zapytań zawierających zakresy dat.



----------------------------------------------------------------------------
-- Rozdział 9.: Wyodrębnianie informacji przez grupowanie i podsumowywanie
----------------------------------------------------------------------------

-- 1. Stwierdzono, że w większości miejsc w ostatnim czasie zmniejszyła się liczba wizyt w bibliotekach. 
-- Jaki jest jednak schemat zatrudnienia w bibliotekach? Wszystkie trzy tabele badań dotyczących bibliotek 
-- zawierają kolumnę totstaff, w której przechowuje się liczbę pracowników zatrudnionych na pełnym etacie. 
-- Zmodyfikuj kod z listingów 9.13 i 9.14, aby obliczyć zmianę procentową w czasie w przypadku sumy wartości kolumny. 
-- Sprawdź wszystkie stany, a także stany z największą liczbą osób odwiedzających. Uważaj na wartości ujemne!

-- Odpowiedź (wszystkie stany):

SELECT pls18.stabr,
       sum(pls18.totstaff) AS totstaff_2018,
       sum(pls17.totstaff) AS totstaff_2017,
       sum(pls16.totstaff) AS totstaff_2016,
       round( (sum(pls18.totstaff::numeric) - sum(pls17.totstaff)) /
            sum(pls17.totstaff) * 100, 1 ) AS chg_2018_17,
       round( (sum(pls17.totstaff::numeric) - sum(pls16.totstaff)) /
            sum(pls16.totstaff) * 100, 1 ) AS chg_2017_16
FROM pls_fy2018_libraries pls18
       JOIN pls_fy2017_libraries pls17 ON pls18.fscskey = pls17.fscskey
       JOIN pls_fy2016_libraries pls16 ON pls18.fscskey = pls16.fscskey
WHERE pls18.totstaff >= 0
       AND pls17.totstaff >= 0
       AND pls16.totstaff >= 0
GROUP BY pls18.stabr
ORDER BY chg_2018_17 DESC;

-- Odpowiedź (filtrowane za pomocą HAVING):

SELECT pls18.stabr,
       sum(pls18.totstaff) AS totstaff_2018,
       sum(pls17.totstaff) AS totstaff_2017,
       sum(pls16.totstaff) AS totstaff_2016,
       round( (sum(pls18.totstaff::numeric) - sum(pls17.totstaff)) /
            sum(pls17.totstaff) * 100, 1 ) AS chg_2018_17,
       round( (sum(pls17.totstaff::numeric) - sum(pls16.totstaff)) /
            sum(pls16.totstaff) * 100, 1 ) AS chg_2017_16
FROM pls_fy2018_libraries pls18
       JOIN pls_fy2017_libraries pls17 ON pls18.fscskey = pls17.fscskey
       JOIN pls_fy2016_libraries pls16 ON pls18.fscskey = pls16.fscskey
WHERE pls18.totstaff >= 0
       AND pls17.totstaff >= 0
       AND pls16.totstaff >= 0
GROUP BY pls18.stabr
HAVING sum(pls18.visits) > 50000000
ORDER BY chg_2018_17 DESC;

-- 2. W tabelach badań dotyczących bibliotek jest kolumna o nazwie obereg zawierająca 2-cyfrowy 
-- kod urzędu BEA (Bureau of Economic Analysis), który klasyfikuje każdą agencję bibliotek zgodnie 
-- z regionem Stanów Zjednoczonych, takim jak Nowa Anglia, Góry Skaliste itp. Tak jak obliczono zmianę 
-- procentową dla liczby wizyt grupowanych według stanu, tak to samo działanie wykonaj w celu pogrupowania 
-- za pomocą kolumny obereg zmian procentowych liczby wizyt według regionów Stanów Zjednoczonych. Zajrzyj 
-- do dokumentacji badań, aby zaznajomić się ze znaczeniem kodu każdego regionu. W ramach dodatkowego 
-- wyzwania utwórz tabelę z kodem kolumny obereg pełniącym rolę klucza głównego oraz z nazwą regionu 
-- jako kolumną tekstową. Dołącz następnie tę tabelę do zapytania podsumowującego w celu pogrupowania 
-- wyników według nazwy regionu, a nie według kodu.

-- Odpowiedź:

-- a) sum() sumuje wizyty według regionu.
    
SELECT pls18.obereg,
       sum(pls18.visits) AS visits_2018,
       sum(pls17.visits) AS visits_2017,
       sum(pls16.visits) AS visits_2016,
       round( (sum(pls18.visits::numeric) - sum(pls17.visits)) /
            sum(pls17.visits) * 100, 1 ) AS chg_2018_17,
       round( (sum(pls17.visits::numeric) - sum(pls16.visits)) /
            sum(pls16.visits) * 100, 1 ) AS chg_2017_16
FROM pls_fy2018_libraries pls18
       JOIN pls_fy2017_libraries pls17 ON pls18.fscskey = pls17.fscskey
       JOIN pls_fy2016_libraries pls16 ON pls18.fscskey = pls16.fscskey
WHERE pls18.visits >= 0
       AND pls17.visits >= 0
       AND pls16.visits >= 0
GROUP BY pls18.obereg
ORDER BY chg_2018_17 DESC;

-- b) Dodatek: tworzenie tabeli wyszukiwania regionów i dodanie jej do zapytania.

CREATE TABLE obereg_codes (
    obereg text CONSTRAINT obereg_key PRIMARY KEY,
    region text
);

INSERT INTO obereg_codes
VALUES ('01', 'New England (CT ME MA NH RI VT)'),
       ('02', 'Mid East (DE DC MD NJ NY PA)'),
       ('03', 'Great Lakes (IL IN MI OH WI)'),
       ('04', 'Plains (IA KS MN MO NE ND SD)'),
       ('05', 'Southeast (AL AR FL GA KY LA MS NC SC TN VA WV)'),
       ('06', 'Soutwest (AZ NM OK TX)'),
       ('07', 'Rocky Mountains (CO ID MT UT WY)'),
       ('08', 'Far West (AK CA HI NV OR WA)'),
       ('09', 'Outlying Areas (AS GU MP PR VI)');

-- a) sum() sumuje wizyty według regionu.

SELECT obereg_codes.region,
       sum(pls18.visits) AS visits_2018,
       sum(pls17.visits) AS visits_2017,
       sum(pls16.visits) AS visits_2016,
       round( (sum(pls18.visits::numeric) - sum(pls17.visits)) /
            sum(pls17.visits) * 100, 1 ) AS chg_2018_17,
       round( (sum(pls17.visits::numeric) - sum(pls16.visits)) /
            sum(pls16.visits) * 100, 1 ) AS chg_2017_16
FROM pls_fy2018_libraries pls18
       JOIN pls_fy2017_libraries pls17 ON pls18.fscskey = pls17.fscskey
       JOIN pls_fy2016_libraries pls16 ON pls18.fscskey = pls16.fscskey
       JOIN obereg_codes ON pls18.obereg = obereg_codes.obereg
WHERE pls18.visits >= 0
       AND pls17.visits >= 0
       AND pls16.visits >= 0
GROUP BY obereg_codes.region
ORDER BY chg_2018_17 DESC;

-- 3. Wracając myślami do typów złączeń omówionych w rozdziale 7., jaki typ złączenia 
-- umożliwi pokazanie wszystkich wierszy każdej z trzech tabel z uwzględnieniem wierszy 
-- bez pasującej wartości? Utwórz takie zapytanie i dodaj w klauzuli WHERE filtr IS NULL, 
-- aby wyświetlić agencje, których nie ma w jednej lub większej liczbie tabel.

-- Odpowiedź: złączenie FULL OUTER JOIN spowoduje wyświetlenie wszystkich wierszy z obu tabel.

SELECT pls18.libname, pls18.city, pls18.stabr, pls18.statstru, 
       pls17.libname, pls17.city, pls17.stabr, pls17.statstru, 
       pls16.libname, pls16.city, pls16.stabr, pls16.statstru
FROM pls_fy2018_libraries pls18
       FULL OUTER JOIN pls_fy2017_libraries pls17 ON pls18.fscskey = pls17.fscskey
       FULL OUTER JOIN pls_fy2016_libraries pls16 ON pls18.fscskey = pls16.fscskey
WHERE pls16.fscskey IS NULL OR pls17.fscskey IS NULL;

-- Note: The IS NULL statements in the WHERE clause limit results to those
-- that do not appear in one or more tables.
-- Uwaga: instrukcje IS NULL w klauzuli WHERE ograniczają wyniki do tych,
-- które nie pojawiają się w jednej lub większej liczbie tabel.


--------------------------------------------------------------
-- Rozdział 10.: Sprawdzanie i modyfikowanie danych
--------------------------------------------------------------

-- W ramach tego ćwiczenia przekształcisz tabelę meat_poultry_egg_establishments do 
-- postaci zapewniającej przydatne informacje. Musisz odpowiedzieć na następujące dwa pytania: 
-- ile zakładów w tabeli zajmuje się przetwórstwem mięsa, a ile z nich specjalizuje się w obróbce drobiu?

-- Twoje zadania są następujące:

-- 1. Utwórz w swojej tabeli dwie nowe kolumny o nazwach meat_processing i poultry_processing. 
-- Każda z nich może być typu boolean.
-- 2. Za pomocą instrukcji UPDATE określ warunek meat_processing = TRUE dla każdego wiersza, 
-- w przypadku którego kolumna activities zawiera tekst Meat Processing (przetwórstwo mięsa). 
-- Taką samą operacji aktualizacji wykonaj względem kolumny poultry_processing, lecz tym razem 
-- w kolumnie activities poszukaj tekstu Poultry Processing (przetwórstwo drobiu).
-- 3. Użyj danych z nowych, zaktualizowanych kolumn, aby ustalić liczbę zakładów zajmujących się 
-- każdym typem działalności. W ramach dodatkowego wyzwania określ, ile zakładów podjęło się 
-- obu rodzajów działalności.

-- Odpowiedź:
-- a) Dodaj kolumny

ALTER TABLE meat_poultry_egg_establishments ADD COLUMN meat_processing boolean;
ALTER TABLE meat_poultry_egg_establishments ADD COLUMN poultry_processing boolean;

SELECT * FROM meat_poultry_egg_establishments; -- wyświetlenie tabeli z nowymi, pustymi kolumnami

-- b) Zaktualizuj kolumny

UPDATE meat_poultry_egg_establishments
SET meat_processing = TRUE
WHERE activities ILIKE '%meat processing%'; -- dopasowywanie za pomocą symboli wieloznacznych bez rozróżniania wielkości znaków

UPDATE meat_poultry_egg_establishments
SET poultry_processing = TRUE
WHERE activities ILIKE '%poultry processing%'; -- dopasowywanie za pomocą symboli wieloznacznych bez rozróżniania wielkości znaków

-- c) Wyświetl zaktualizowaną tabelę

SELECT * FROM meat_poultry_egg_establishments;

-- d) Ustalanie liczby firm przetwarzających mięso lub drób

SELECT count(meat_processing), count(poultry_processing)
FROM meat_poultry_egg_establishments;

-- e) Count those who do both
-- e) Ustalanie liczby firm przetwarzających mięso i drób

SELECT count(*)
FROM meat_poultry_egg_establishments
WHERE meat_processing = TRUE AND
      poultry_processing = TRUE;

----------------------------------------------------------------------------
-- Rozdział 11.: Funkcje statystyczne języka SQL
----------------------------------------------------------------------------

-- 1. Po zastosowaniu kodu z listingu 11.2 wartość współczynnika korelacji lub wartość r 
-- wynosiła około 0,70 w przypadku zmiennych pct_bachelors_higher i median_hh_income. 
-- Używając tego samego zbioru danych, utwórz zapytanie ujawniające korelację między 
-- zmiennymi pct_masters_higher i median_hh_income. Czy wartość r jest większa czy mniejsza? 
-- Co może stanowić wyjaśnienie zaistniałej różnicy?

-- Odpowiedź:
-- Wartość r dla pct_masters_higher i median_hh_income wynosi około .60, co
-- wskazuje na mniejszy stopień powiązania odsetka osób z tytułem magistra lub wyższym a
-- dochodem niż odsetka osób z tytułem licencjata lub wyższym. Jednym z możliwych
-- wyjaśnień jest to, że uzyskanie tytułu magistra lub wyższego może mieć bardziej
-- stopniowy wpływ na zarobki niż uzyskanie tytułu licencjata.


SELECT
    round(
      corr(median_hh_income, pct_bachelors_higher)::numeric, 2
      ) AS bachelors_income_r,
    round(
      corr(median_hh_income, pct_masters_higher)::numeric, 2
      ) AS masters_income_r
FROM acs_2014_2018_stats;


-- 2. Posługując się danymi dotyczącymi eksportu, utwórz 12-miesięczną sumę kroczącą z 
-- użyciem wartości zawartych w kolumnie soybeans_export_value oraz schematu zapytania z listingu 11.8. 
-- Skopiuj i wklej wyniki z panelu danych wyjściowych narzędzia pgAdmin i pokaż wartości 
-- na wykresie za pomocą programu Excel. Jaki dostrzegasz trend?  

-- Odpowiedź: Eksport soi znacznie wzrósł pod koniec dekady po roku 2000.
-- i znacznie spadł od 2018 roku po rozpoczęciu wojny handlowej 
-- Stanów Zjednoczonych z Chinami.


SELECT year, month, soybeans_export_value,
    round(   
       sum(soybeans_export_value) 
            OVER(ORDER BY year, month 
                 ROWS BETWEEN 11 PRECEDING AND CURRENT ROW), 0)
       AS twelve_month_avg
FROM us_exports
ORDER BY year, month;

-- 3. W ramach dodatkowego wyzwania ponownie sprawdź dane dotyczące bibliotek 
-- znajdujące się w tabeli pls_fy2018_libraries z rozdziału 9. Sporządź ranking 
-- agencji bibliotek na podstawie liczby wizyt w przeliczeniu na populację liczącą 
-- 1000 osób (kolumna popu_lsa) oraz ogranicz wyniki zapytania do agencji 
-- obsługujący co najmniej 250 000 osób.

-- Odpowiedź:
-- Pinellas Public Library Coop zajmuje pierwsze miejsce w rankingu z 9705 wizytami 
-- przypadającymi na tysiąc osób (czyli około 10 wizyt na osobę).

SELECT
    libname,
    stabr,
    visits,
    popu_lsa,
    round(
        (visits::numeric / popu_lsa) * 1000, 1
        ) AS visits_per_1000,
    rank() OVER (ORDER BY (visits::numeric / popu_lsa) * 1000 DESC)
FROM pls_fy2018_libraries
WHERE popu_lsa >= 250000;


----------------------------------------------------------------------------
-- Rozdział 12.: Przetwarzanie dat i czasu
----------------------------------------------------------------------------

-- 1.	Korzystając z danych dotyczących taksówek w Nowym Jorku oraz 
-- bazując na znacznikach czasu rozpoczęcia i zakończenia podróży, 
-- oblicz czas trwania każdego kursu. Posortuj wyniki zapytania w 
-- kolejności od najdłużej do najkrócej trwających kursów. 
-- Czy dostrzegasz cokolwiek związanego z najdłuższymi lub najkrótszymi 
-- kursami, o co można zapytać przedstawiciel władz miasta?

-- Odpowiedź: ponad 480 kursów trwa ponad 10 godzin, co wydaje się nadmiernym czasem. 
-- Ponadto, w dwóch rekordach czas zakończenia następuje przed czasem rozpoczęcia kursu,
-- a w kilku rekordach czas rozpoczęcia i zakończenia jest taki sam. Warto zapytać, 
-- czy te rekordy zawierają błędy w znacznikach czasu.


SELECT
    trip_id,
    tpep_pickup_datetime,
    tpep_dropoff_datetime,
    tpep_dropoff_datetime - tpep_pickup_datetime AS length_of_ride
FROM nyc_yellow_taxi_trips
ORDER BY length_of_ride DESC;

-- 2. Stosując słowa kluczowe AT TIME ZONE, utwórz zapytanie wyświetlające 
-- w przypadku rozpoczynającego się w Nowym Jorku dnia 1 stycznia 2100 r. datę 
-- i godzinę dla Londynu, Johannesburga, Moskwy i Melbourne. Użyj kodu z 
-- listingu 12.5 do znalezienia nazw stref czasowych.

-- Odpowiedź:

SELECT '2100-01-01 00:00:00-05' AT TIME ZONE 'US/Eastern' AS new_york,
       '2100-01-01 00:00:00-05' AT TIME ZONE 'Europe/London' AS london,
       '2100-01-01 00:00:00-05' AT TIME ZONE 'Africa/Johannesburg' AS johannesburg,
       '2100-01-01 00:00:00-05' AT TIME ZONE 'Europe/Moscow' AS moscow,
       '2100-01-01 00:00:00-05' AT TIME ZONE 'Australia/Melbourne' AS melbourne;

-- 3. W ramach dodatkowego wyzwania zastosuj funkcje statystyczne z rozdziału 11. 
-- do obliczenia wartości współczynnika korelacji i r-kwadratu. W tym celu użyj 
-- czasu trwania podróży i wartości z kolumny total_amount zawartej w danych 
-- dotyczących taksówek nowojorskich, która reprezentuje całkowitą kwotą, 
-- jaką zapłacili pasażerowie. Tak samo postąp w przypadku kolumn trip_distance i total_amount. 
-- Ogranicz wyniki zapytania do kursów, które trwały nie dłużej niż 3 godziny.

-- Odpowiedź:

SELECT
    round(
          corr(total_amount, (
              date_part('epoch', tpep_dropoff_datetime) -
              date_part('epoch', tpep_pickup_datetime)
                ))::numeric, 2
          ) AS amount_time_corr,
    round(
        regr_r2(total_amount, (
              date_part('epoch', tpep_dropoff_datetime) -
              date_part('epoch', tpep_pickup_datetime)
        ))::numeric, 2
    ) AS amount_time_r2,
    round(
          corr(total_amount, trip_distance)::numeric, 2
          ) AS amount_distance_corr,
    round(
        regr_r2(total_amount, trip_distance)::numeric, 2
    ) AS amount_distance_r2
FROM nyc_yellow_taxi_trips
WHERE tpep_dropoff_datetime - tpep_pickup_datetime <= '3 hours'::interval;

-- Uwaga: obie korelacje są silne z wartościami r wynoszącymi 0.80 lub więcej. 
-- Można było tego oczekiwać, biorąc pod uwagę to, że koszt przejazdu taksówką 
-- bazuje zarówno na czasie, jak i odległości.


----------------------------------------------------------------------------
-- Rozdział 13.: Zaawansowane techniki tworzenia zapytań
----------------------------------------------------------------------------

-- 1. Skoryguj kod z listingu 13.21 w celu zagłębienia się w niuanse wysokich 
-- temperatur w Waikiki. Ogranicz dane z tabeli temps_collapsed do dziennych 
-- odczytów maksymalnej temperatury w Waikiki. Użyj następnie w instrukcji CASE 
-- klauzul WHEN do przeprowadzenia ponownej klasyfikacji temperatur przy użyciu 7 grup, 
-- co spowoduje uzyskanie następujących tekstowych danych wynikowych:

-- '90 lub więcej'
-- '88-89'
-- '86-87'
-- '84-85'
-- '82-83'
-- '80-81'
-- '79 lub mniej'

-- Do której z tych grup najczęściej są przypisywane 
-- dzienne odczyty temperatur w Waikiki?

-- Odpowiedź: między 86 a 87 stopni Fahrenheita. Przyjemnie.

WITH temps_collapsed (station_name, max_temperature_group) AS
    (SELECT station_name,
           CASE WHEN max_temp >= 90 THEN '90 or more'
                WHEN max_temp >= 88 AND max_temp < 90 THEN '88-89'
                WHEN max_temp >= 86 AND max_temp < 88 THEN '86-87'
                WHEN max_temp >= 84 AND max_temp < 86 THEN '84-85'
                WHEN max_temp >= 82 AND max_temp < 84 THEN '82-83'
                WHEN max_temp >= 80 AND max_temp < 82 THEN '80-81'
                WHEN max_temp < 80 THEN '79 or less'
            END
    FROM temperature_readings
    WHERE station_name = 'WAIKIKI 717.2 HI US')

SELECT station_name, max_temperature_group, count(*)
FROM temps_collapsed
GROUP BY station_name, max_temperature_group
ORDER BY max_temperature_group;

-- 2. Zmodyfikuj kod z listingu 13.17, aby dokonać odwrócenia tworzonej 
-- przez niego tabeli krzyżowej z danymi ankiety dotyczącej lodów. Inaczej 
-- mówiąc, spraw, że wartości kolumny flavor będą wierszami, a wartości kolumny 
-- office — kolumnami. Jakie musisz zmodyfikować elementy zapytania? 
-- Czy uzyskane liczby są inne?

-- Odpowiedź: musisz zmienić kolejność kolumn w pierwszym podzapytaniu, 
-- tak aby smak był pierwszy, oddział drugi, a funkcja count(*) trzecia. Musisz 
-- następnie zmienić drugie podzapytanie, aby uzyskać pogrupowaną listę oddziałów. 
-- Na koniec musisz dodać nazwy oddziałów do listy wynikowej.

-- Liczby  nie zmieniają się, a jedynie kolejność w tabeli przestawnej.

SELECT *
FROM crosstab('SELECT flavor,
                      office,
                      count(*)
               FROM ice_cream_survey
               GROUP BY flavor, office
               ORDER BY flavor',

              'SELECT office
               FROM ice_cream_survey
               GROUP BY office
               ORDER BY office')

AS (flavor text,
    downtown bigint,
    midtown bigint,
    uptown bigint);


----------------------------------------------------------------------------
-- Rozdział 14.: Przeszukiwanie tekstu w celu znalezienia wartościowych danych
----------------------------------------------------------------------------

-- 1. W przewodniku stylów firmy wydawniczej, dla której piszesz tekst, 
-- wymaga się, aby unikać przecinków przed przyrostkami w obrębie imion i nazwisk. 
-- W Twojej bazie danych znajduje się jednak kilka imion i nazwisk zapisanych w 
-- takiej postaci jak Alvarez, Jr. i Williams, Sr.. Jakich funkcji możesz użyć 
-- do usunięcia przecinka? Czy pomocna byłaby funkcja wyrażenia regularnego? 
-- Jak przechwyciłbyś tylko przyrostki, aby umieścić je w osobnej kolumnie?

-- Odpowiedź: możesz użyć standardowej funkcji replace() języka SQL 
-- lub funkcji regexp_replace() systemu PostgreSQL:

SELECT replace('Williams, Sr.', ', ', ' ');
SELECT regexp_replace('Williams, Sr.', ', ', ' ');

-- Odpowiedź: aby przechwycić tylko przyrostki, wyszukaj znaków po przecinku
-- i spacji oraz umieść je w grupie dopasowywania:


SELECT (regexp_match('Williams, Sr.', '.*, (.*)'))[1];


-- 2. Używając dowolnego z przemówień prezydenckich, ustal liczbę unikalnych 
-- słów mających co najmniej pięć znaków (wskazówka: możesz zastosować w 
-- podzapytaniu funkcję regexp_split_to_table() w celu utworzenia tabeli ze 
-- słowami do policzenia). Bonus: usuń przecinki i kropki na końcu każdego słowa.

-- Odpowiedź:
-- Zapytanie używa wyrażenia CTE, aby najpierw rozdzielić każde słowo
-- w tekście w osobnym wierszu tabeli o nazwie word_list. Polecenie SELECT zlicza
-- następnie słowa, które są oczyszczane w ramach dwóch operacji. Po pierwsze,
-- kilka zagnieżdżonych funkcji replace usuwa przecinki, kropki i dwukropki. Po drugie,
-- wszystkie słowa są przekształcane na zawierające małe litery, aby podczas zliczania
-- grupować słowa, które mogą mieć znaki o różnej wielkości (np. "Military" i "military").


WITH
    word_list (word)
AS
    (
        SELECT regexp_split_to_table(speech_text, '\s') AS word
        FROM president_speeches
        WHERE speech_date = '1946-01-21'
    )

SELECT lower(
               replace(replace(replace(word, ',', ''), '.', ''), ':', '')
             ) AS cleaned_word,
       count(*)
FROM word_list
WHERE length(word) >= 5
GROUP BY cleaned_word
ORDER BY count(*) DESC;


-- 3.	Przebuduj zapytanie z listingu 14.25 wstawiając funkcję ts_rank_cd() 
-- w miejsce funkcji ts_rank(). Zgodnie z dokumentacją systemu PostgreSQL, 
-- funkcja ts_rank_cd() oblicza gęstość pokrycia, która uwzględnia to, jak 
-- blisko siebie są położone terminy wyszukiwania z leksemem. Czy użycie tej 
-- funkcji wpłynie znacząco na zmianę wyników?

-- Odpowiedź:
-- Ranking zmienia się, wyróżniając przemówienia George'a W. Busha po 11 września.
-- Zmiana może być bardziej lub mniej wyraźna dla innego zestawu tekstów.


SELECT president,
       speech_date,
       ts_rank_cd(search_speech_text, search_query, 2) AS rank_score
FROM president_speeches,
     to_tsquery('war & security & threat & enemy') search_query
WHERE search_speech_text @@ search_query
ORDER BY rank_score DESC
LIMIT 5;


----------------------------------------------------------------------------
-- Rozdział 15.: Analizowanie danych przestrzennych za pomocą rozszerzenia PostGIS
----------------------------------------------------------------------------

-- 1. Wcześniej stwierdziłeś, jakie hrabstwo w Stanach Zjednoczonych ma 
-- największą powierzchnię. Zagreguj teraz dane o hrabstwach, aby ustalić 
-- powierzchnię każdego stanu wyrażoną w milach kwadratowych (zastosuj 
-- kolumnę statefp z tabeli us_counties_2019_shp). Ile stanów jest większych 
-- niż okręg Yukon-Koyukuk?

-- Odpowiedź: tylko trzy stany są większe niż Yukon-Koyukuk. Oczywiście
-- jeden z nich to sama Alaska (kod FIPS 02). Pozostałe dwa to Teksas (kod FIPS 48)
-- i Kalifornia (kod FIPS 06).

SELECT statefp AS st,
       round (
              ( sum(ST_Area(geom::geography) / 2589988.110336))::numeric, 2
             ) AS square_miles
FROM us_counties_2019_shp
GROUP BY statefp
ORDER BY square_miles DESC;

-- 2. Używając funkcji ST_Distance(), określ, ile mil oddziela następujące 
-- dwa targi rolnicze: The Oakleaf Greenmarket (9700 Argyle Forest Blvd, 
-- Jacksonville, Floryda) i Columbia Farmers Market (1701 West Ash Street, 
-- Columbia, Missouri). Będziesz musiał najpierw znaleźć w tabeli farmers_markets 
-- współrzędne lokalizacji obu targów. Wskazówka: możesz też utworzyć odpowiednie 
-- zapytanie z użyciem poznanej w rozdziale 13. składni wyrażeń CTE (Common Table Expression).

-- Odpowiedź: około 851 mil.

WITH
    market_start (geog_point) AS
    (
     SELECT geog_point
     FROM farmers_markets
     WHERE market_name = 'The Oakleaf Greenmarket'
    ),
    market_end (geog_point) AS
    (
     SELECT geog_point
     FROM farmers_markets
     WHERE market_name = 'Columbia Farmers Market'
    )
SELECT ST_Distance(market_start.geog_point, market_end.geog_point) / 1609.344 -- przekształcenie metrów na mile
FROM market_start, market_end;

-- 3.	W przypadku ponad 500 wierszy tabeli farmers_markets brakuje wartości 
-- w kolumnie county, co jest przykładem niekompletnych danych rządowych. 
-- Korzystając z tabeli us_counties_2019_shp oraz z funkcji ST_Intersects(), 
-- na podstawie długości i szerokości geograficznej położenia każdego targu 
-- utwórz złączenie danych przestrzennych w celu znalezienia brakujących nazw hrabstw. 
-- Ponieważ kolumna geog_point w tabeli farmers_markets jest typu geography, a 
-- powiązany identyfikator SRID ma wartość 4326, konieczne będzie rzutowanie typu 
-- kolumny geom tabeli danych spisu ludności na typ geography oraz zmiana wartości 
-- tego identyfikatora za pomocą funkcji ST_SetSRID().

-- Odpowiedź:

SELECT census.name,
       census.statefp,
       markets.market_name,
       markets.county,
       markets.st
FROM farmers_markets markets JOIN us_counties_2019_shp census
    ON ST_Intersects(markets.geog_point, ST_SetSRID(census.geom,4326)::geography)
    WHERE markets.county IS NULL
ORDER BY census.statefp, census.name;

-- Zauważ, że zapytanie zwraca 496 wierszy. Nie wszystkie kolumny z brakującą wartością 
-- w kolumnie county mają wartości w kolumnach geog_point, latitude i longitude.

-- Ponadto, zapytanie to wyróżnia targ rolniczy, który ma błędne współrzędne geograficzne.
-- Czy możesz to wychwycić?

-- 4. Utworzona w rozdziale 12. tabela nyc_yellow_taxi_trips zawiera długość i 
-- szerokość geograficzną miejsca rozpoczęcia i zakończenia każdego kursu taksówki. 
-- Użyj funkcji rozszerzenia PostGIS do przekształcenia współrzędnych miejsca, gdzie 
-- pasażer wysiadł, w dane typu geometry, a ponadto ustal liczbę par stan-hrabstwo, 
-- w przypadku których miało miejsce każde zakończenie kursu. Jak w poprzednim ćwiczeniu 
-- konieczne będzie złączenie tabeli us_counties_2019_shp i zastosowanie jej kolumny geom 
-- do utworzenia złączenia danych przestrzennych.

-- Odpowiedź:

SELECT census.statefp,
       census.name as county,
       count(*) AS dropoffs
FROM nyc_yellow_taxi_trips taxi JOIN us_counties_2019_shp census
ON ST_Within(
            ST_SetSRID(ST_MakePoint(taxi.dropoff_longitude, taxi.dropoff_latitude),4269)::geometry, census.geom
            )
GROUP BY census.statefp, census.name
ORDER BY count(*) DESC;

-- Dziękujemy Czytelnikowi Ericowi Mortensonowi za zasugerowanie tego ćwiczenia.


----------------------------------------------------------------------------
-- Rozdział 16.: Użycie danych formatu JSON
----------------------------------------------------------------------------

-- 1. W danych JSON dotyczących trzęsień ziemi znajduje się klucz tsunami z 
-- ustawioną wartością 1 w przypadku dużych trzęsień na obszarach oceanicznych 
-- (choć nie oznacza to, że tsunami faktycznie miało miejsce). Używając operatora 
-- wyodrębniania pól lub operatora wyodrębniania ze ścieżki, znajdź trzęsienia 
-- ziemi z kluczem tsunami o wartości 1, a ponadto w wynikach uwzględnij ich 
-- lokalizację, czas wystąpienia i magnitudę.

-- Odpowiedź:

SELECT earthquake -> 'properties' ->> 'place' AS place,
       to_timestamp((earthquake -> 'properties' ->> 'time')::bigint / 1000) AS timestamp,
       (earthquake -> 'properties' ->> 'mag')::numeric AS mag
FROM earthquakes
WHERE (earthquake -> 'properties' ->> 'tsunami') = '1';

-- Ten sam wynik, ale z użyciem operatorów wyodrębniania ze ścieżki zamiast operatorów wyodrębniania pól
SELECT earthquake #>> '{properties, place}' AS place,
       to_timestamp((earthquake -> 'properties' ->> 'time')::bigint / 1000) AS timestamp,
       (earthquake #>> '{properties, mag}')::numeric AS mag
FROM earthquakes
WHERE (earthquake #>> '{properties, tsunami}') = '1';

-- 2. Zastosuj następującą instrukcję CREATE TABLE, aby do bazy danych analysis dodać tabelę earthquakes_from_json:

CREATE TABLE earthquakes_from_json (
    id text PRIMARY KEY,
    title text,
    type text,
    quake_date timestamp with time zone,
    mag numeric,
    place text,
    earthquake_point geography(POINT, 4326),
    url text
);

-- Używając operatora wyodrębniania pól i operatora wyodrębniania ze ścieżki, 
-- utwórz instrukcję INSERT w celu wypełnienia tabeli poprawnymi wartościami 
-- dla każdego trzęsienia ziemi. Aby uzyskać dowolne wymagane nazwy kluczy i 
-- ścieżki, skorzystaj z kompletnych, przykładowych danych JSON dotyczących 
-- trzęsień ziemi zawartych w pliku Chapter_16.sql.

-- Odpowiedź:
-- Zauważ, że do pobrania potrzebnych elementów możesz użyć zarówno operatorów pól, jak i operatorów ścieżek.

INSERT INTO earthquakes_from_json
SELECT earthquake ->> 'id',
       earthquake -> 'properties' ->> 'title',
       earthquake -> 'properties' ->> 'type',
       to_timestamp((earthquake -> 'properties' ->> 'time')::bigint / 1000),
       (earthquake -> 'properties' ->> 'mag')::numeric,
       earthquake -> 'properties' ->> 'place',
       ST_SetSRID(
            ST_MakePoint(
                (earthquake #>> '{geometry, coordinates, 0}')::numeric,
                (earthquake #>> '{geometry, coordinates, 1}')::numeric
             ),
                 4326)::geography,
       earthquake -> 'properties' ->> 'url'
FROM earthquakes;

-- Wyświetlenie skopiowanych danych:
SELECT * FROM earthquakes_from_json;


-- 3. Dodatkowe (trudne) zadanie: spróbuj utworzyć zapytanie generujące 
-- następujące dane JSON przy użyciu tabel teachers i teachers_lab_access z rozdziału 13.:
{
	"id": 6,
	"fn": "Kathleen",
	"ln": "Roush",
	"lab_access": [{
		"lab_name": "Science B",
		"access_time": "2022-12-17T16:00:00-05:00"
	}, {
		"lab_name": "Science A",
		"access_time": "2022-12-07T10:02:00-05:00"
	}]
}
-- Warto pamiętać, że tabela teachers tworzy relację jeden-do-wielu z tabelą teachers_lab_access. 
-- Pierwsze trzy klucze muszą pochodzić z tabeli teachers, a obiekty JSON w tablicy lab_access 
-- będą pochodzić z tabeli teachers_lab_access. 
-- Wskazówka: aby utworzyć tablicę lab_access, konieczne będzie użycie podzapytania w obrębie listy instrukcji SELECT i funkcji o 
-- nazwie json_agg().

-- Odpowiedź:

SELECT to_json(teachers_labs)
FROM (
    SELECT id,
           first_name AS fn,
           last_name AS ln,
        (
            SELECT json_agg(to_json(la))
            FROM (
                SELECT lab_name, access_time
                FROM teachers_lab_access
                WHERE teacher_id = teachers.id
                ORDER BY access_time DESC
            ) AS la
        ) AS lab_access
    FROM teachers 
    WHERE id = 6)
AS teachers_labs;

-- Co ma tutaj miejsce? Pod względem strukturalnym występuje seria zagnieżdżonych podzapytań.
-- Do pobrania kolumn id, first_name i last_name z tabeli teachers użyto pierwszego 
-- podzapytania. Na liście instrukcji SELECT tego podzapytania umieszczono kolejne podzapytanie, które
-- pobiera kolumny lab_name i access_time z tabeli teachers_lab_access.


-- Co sprawia, że to zapytanie jest złożone, to konieczność użycia wewnętrznego podzapytania do wygenerowania
-- obiektów tablicy lab_access i użycia funkcji json_agg w celu zagregowania wyników tych wierszy w tablicy.


-- W trakcie tworzenia takiego zapytania pomocne jest podejście etapowe. Zacznij od
-- najbardziej zewnętrznego zapytania i dodawaj podzapytania jedno po drugim, 
-- testując je w miarę postępów.


----------------------------------------------------------------------------
-- Rozdział 17.: Oszczędzanie czasu dzięki widokom, funkcjom i wyzwalaczom
----------------------------------------------------------------------------

-- 1. Utwórz widok zmaterializowany, który wyświetla liczbę wykonanych w ciągu 
-- godziny kursów przez taksówki w Nowym Jorku. Użyj danych dotyczących taksówek 
-- z rozdziału 12. oraz zapytania z listingu 12.8. Jak w razie potrzeby odświeżysz widok?

-- Odpowiedź:

CREATE MATERIALIZED VIEW nyc_taxi_trips_per_hour AS
    SELECT
        date_part('hour', tpep_pickup_datetime) AS trip_hour,
        count(*)
    FROM nyc_yellow_taxi_trips
    GROUP BY trip_hour
    ORDER BY trip_hour;

SELECT * FROM nyc_taxi_trips_per_hour;

-- Operacja odświeżania:

REFRESH MATERIALIZED VIEW nyc_taxi_trips_per_hour;

-- 2. W rozdziale 11. dowiedziałeś się, w jaki sposób obliczyć liczbę urodzeń 
-- w przeliczeniu na 1000 kobiet. Przekształć użyty w tym celu wzór do postaci 
-- funkcji rate_per_thousand(), która do obliczenia wyniku pobiera następujące 
-- trzy argumenty: observed_number (zanotowana liczba urodzeń), base_number (liczba bazowa) 
-- i decimal_places (liczba miejsc dziesiętnych).

-- Odpowiedź: użyto tutaj elementów języka PL/pgSQL, ale można też zastosować funkcję języka SQL.

CREATE OR REPLACE FUNCTION
    rate_per_thousand(observed_number numeric,
                      base_number numeric,
                      decimal_places integer DEFAULT 1)
RETURNS numeric(10,2) AS $$
BEGIN
    RETURN
        round(
        (observed_number / base_number) * 1000, decimal_places
        );
END;
$$ LANGUAGE plpgsql;

-- Testowanie funkcji:

SELECT rate_per_thousand(50, 11000, 2);

-- 3. W rozdziale 10. zajmowałeś się tabelą meat_poultry_egg_establishments, 
-- w której zestawiono zakłady produkujące żywność. Utwórz wyzwalacz automatycznie 
-- dodający znacznik czasu najpóźniejszego terminu inspekcji ustalonego na 6 miesięcy 
-- do przodu każdorazowo po wstawieniu do tabeli danych o nowym zakładzie. 
-- Skorzystaj z kolumny inspection_deadline dodanej za pomocą kodu z listingu 10.19. 
-- Powinieneś być w stanie opisać kroki niezbędne do implementacji wyzwalacza, 
-- a także wyjaśnić, jak kroki są ze sobą powiązane.

-- Odpowiedź:
-- a) Powinna już istnieć kolumna inspection_deadline. Jeśli nie, dodaj ją:

ALTER TABLE meat_poultry_egg_establishments ADD COLUMN inspection_deadline timestamp with time zone;

-- b) Utwórz funkcję, którą wywoła wyzwalacz.

CREATE OR REPLACE FUNCTION add_inspection_deadline()
    RETURNS trigger AS $$
    BEGIN
       NEW.inspection_deadline = now() + '6 months'::interval; -- Here, we set the inspection date to six months in the future
    RETURN NEW;
    END;
$$ LANGUAGE plpgsql;

-- c) Utwórz wyzwalacz

CREATE TRIGGER inspection_deadline_update
  BEFORE INSERT
  ON meat_poultry_egg_establishments
  FOR EACH ROW
  EXECUTE PROCEDURE add_inspection_deadline();

-- d) Przetestuj operację wstawiania firmy i sprawdź wynik

INSERT INTO meat_poultry_egg_establishments(establishment_number, company)
VALUES ('test123', 'testcompany');

SELECT * FROM meat_poultry_egg_establishments
WHERE company = 'testcompany';


